package main

import (
	"log"
	"net/http"
	"time"
)

func sendPing() {
	client := &http.Client{Timeout: 10 * time.Second}
	resp, err := client.Get("http://localhost:8080/ping")
	if err != nil {
		log.Printf("Ping failed: %v", err)
		return
	}
	defer resp.Body.Close()
}

func main() {
	ticker := time.NewTicker(10 * time.Second)
	sendPing()
	for range ticker.C {
		sendPing()
	}
}
